/*
 * Decompiled with CFR 0.152.
 */
package com.articles.repo.domain;

import com.articles.repo.domain.Chapter;
import com.articles.repo.domain.Comment;
import com.articles.repo.domain.Tag;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="articles")
public class Article {
    @Id
    private String id;
    @Enumerated(value=EnumType.STRING)
    private Chapter chapter;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Tag> tags = new ArrayList();
    private String title;
    @Lob
    @Column(columnDefinition="TEXT")
    private String text;
    private long views;
    private long likes;
    @Transient
    private String keywords;
    @OneToMany(mappedBy="article", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="date DESC")
    private List<Comment> comments;
    private Instant lastModified;

    public String getId() {
        return this.id;
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public long getViews() {
        return this.views;
    }

    public long getLikes() {
        return this.likes;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setChapter(Chapter chapter) {
        this.chapter = chapter;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setViews(long views) {
        this.views = views;
    }

    public void setLikes(long likes) {
        this.likes = likes;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public void setLastModified(Instant lastModified) {
        this.lastModified = lastModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Article)) {
            return false;
        }
        Article other = (Article)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getViews() != other.getViews()) {
            return false;
        }
        if (this.getLikes() != other.getLikes()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Chapter this$chapter = this.getChapter();
        Chapter other$chapter = other.getChapter();
        if (this$chapter == null ? other$chapter != null : !this$chapter.equals(other$chapter)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$keywords = this.getKeywords();
        String other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !this$keywords.equals(other$keywords)) {
            return false;
        }
        List this$comments = this.getComments();
        List other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !((Object)this$comments).equals(other$comments)) {
            return false;
        }
        Instant this$lastModified = this.getLastModified();
        Instant other$lastModified = other.getLastModified();
        return !(this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Article;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $views = this.getViews();
        result = result * 59 + (int)($views >>> 32 ^ $views);
        long $likes = this.getLikes();
        result = result * 59 + (int)($likes >>> 32 ^ $likes);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Chapter $chapter = this.getChapter();
        result = result * 59 + ($chapter == null ? 43 : $chapter.hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : $keywords.hashCode());
        List $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : ((Object)$comments).hashCode());
        Instant $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        return result;
    }

    public String toString() {
        return "Article(id=" + this.getId() + ", chapter=" + String.valueOf(this.getChapter()) + ", tags=" + String.valueOf(this.getTags()) + ", title=" + this.getTitle() + ", text=" + this.getText() + ", views=" + this.getViews() + ", likes=" + this.getLikes() + ", keywords=" + this.getKeywords() + ", comments=" + String.valueOf(this.getComments()) + ", lastModified=" + String.valueOf(this.getLastModified()) + ")";
    }

    public Article() {
    }

    public Article(String id, Chapter chapter, List<Tag> tags, String title, String text, long views, long likes, String keywords, List<Comment> comments, Instant lastModified) {
        this.id = id;
        this.chapter = chapter;
        this.tags = tags;
        this.title = title;
        this.text = text;
        this.views = views;
        this.likes = likes;
        this.keywords = keywords;
        this.comments = comments;
        this.lastModified = lastModified;
    }
}

